# 🚀 **Backend PHP para Biblio Oportunidades**

## 📋 **Configuración del Backend**

### 1. **Requisitos del Servidor**
- PHP 7.4 o superior
- MySQL 5.7 o superior / MariaDB 10.3 o superior
- Extensiones PHP requeridas:
  - `pdo`
  - `pdo_mysql`
  - `json`

### 2. **Configuración de la Base de Datos**

#### Paso 1: Crear la Base de Datos
```sql
CREATE DATABASE biblio_oportunidades_db;
USE biblio_oportunidades_db;
```

#### Paso 2: Ejecutar el Script de Creación
Ejecuta el archivo `database/create_tables_compatible.sql` en tu base de datos.

#### Paso 3: Ejecutar los Índices
Ejecuta el archivo `database/create_indexes.sql` en tu base de datos.

### 3. **Configuración de los Archivos PHP**

#### Actualizar Configuración de BD
En cada archivo PHP del backend (`backend/*.php`), actualiza estos valores:

```php
$host = 'localhost'; // Tu host de MySQL
$dbname = 'biblio_oportunidades_db'; // Nombre de tu base de datos
$username = 'tu_usuario_mysql'; // Tu usuario de MySQL
$password = 'tu_contraseña_mysql'; // Tu contraseña de MySQL
```

### 4. **Configuración del Servicio Flutter**

#### Actualizar URL del API
En `lib/services/mysql_service.dart`, actualiza:

```dart
static const String baseUrl = 'https://tu-dominio.com/api'; // Tu URL real
```

### 5. **Estructura de Archivos del Backend**

```
backend/
├── register.php          # Registro de usuarios
├── verify-email.php       # Verificación de email
├── login.php             # Login de usuarios
├── check-email.php       # Verificar si email existe
└── update-profile.php    # Actualizar perfil (opcional)
```

### 6. **Endpoints del API**

#### **POST /register.php**
Registra un nuevo usuario y genera contraseña temporal.

**Request:**
```json
{
  "first_name": "María",
  "last_name": "González",
  "email": "maria@example.com",
  "birth_date": "1990-05-15"
}
```

**Response (201):**
```json
{
  "success": true,
  "message": "Usuario registrado exitosamente",
  "temporary_password": "ABC123XY",
  "user": {
    "id": "1",
    "first_name": "María",
    "last_name": "González",
    "email": "maria@example.com",
    "birth_date": "1990-05-15",
    "created_at": "2025-01-01T10:00:00Z",
    "is_email_verified": false,
    "interests": ""
  }
}
```

#### **POST /verify-email.php**
Verifica el email con contraseña temporal.

**Request:**
```json
{
  "email": "maria@example.com",
  "temporary_password": "ABC123XY"
}
```

**Response (200):**
```json
{
  "success": true,
  "message": "Email verificado exitosamente",
  "user": {
    "id": "1",
    "first_name": "María",
    "last_name": "González",
    "email": "maria@example.com",
    "birth_date": "1990-05-15",
    "created_at": "2025-01-01T10:00:00Z",
    "is_email_verified": true,
    "interests": ""
  }
}
```

#### **POST /login.php**
Login con email y contraseña.

**Request:**
```json
{
  "email": "maria@example.com",
  "password": "mi_contraseña_segura"
}
```

**Response (200):**
```json
{
  "success": true,
  "message": "Login exitoso",
  "user": {
    "id": "1",
    "first_name": "María",
    "last_name": "González",
    "email": "maria@example.com",
    "birth_date": "1990-05-15",
    "created_at": "2025-01-01T10:00:00Z",
    "is_email_verified": true,
    "interests": ""
  }
}
```

#### **POST /check-email.php**
Verifica si un email ya existe.

**Request:**
```json
{
  "email": "maria@example.com"
}
```

**Response (200):**
```json
{
  "exists": true
}
```

### 7. **Configuración para Hosting Compartido**

#### .htaccess (opcional)
```apache
# Habilitar CORS
Header add Access-Control-Allow-Origin "*"
Header add Access-Control-Allow-Headers "origin, x-requested-with, content-type"
Header add Access-Control-Allow-Methods "PUT, GET, POST, DELETE, OPTIONS"

# Configuración PHP
php_value upload_max_filesize 32M
php_value post_max_size 32M
php_value memory_limit 128M
php_value max_execution_time 300
php_value max_input_vars 1000
```

### 8. **Testing del Backend**

#### Usar cURL para probar:

```bash
# Registrar usuario
curl -X POST https://tu-dominio.com/api/register.php \
  -H "Content-Type: application/json" \
  -d '{
    "first_name": "Test",
    "last_name": "User",
    "email": "test@example.com",
    "birth_date": "1995-01-01"
  }'

# Verificar email
curl -X POST https://tu-dominio.com/api/verify-email.php \
  -H "Content-Type: application/json" \
  -d '{
    "email": "test@example.com",
    "temporary_password": "ABC123XY"
  }'
```

### 9. **Seguridad**

#### Consideraciones importantes:
- ✅ Validación de entrada en todos los endpoints
- ✅ Uso de prepared statements para prevenir SQL injection
- ✅ Headers CORS configurados
- ✅ Contraseñas hasheadas con `password_hash()`
- ✅ Validación de email format
- ⚠️ **Pendiente:** Autenticación JWT para endpoints protegidos
- ⚠️ **Pendiente:** Rate limiting para prevenir spam
- ⚠️ **Pendiente:** Logging de errores

### 10. **Monitoreo y Logs**

#### Para debugging, puedes agregar logs:
```php
// Al inicio de cada archivo PHP
error_log("API Call: " . $_SERVER['REQUEST_URI'] . " - " . date('Y-m-d H:i:s'));
```

## 🔧 **Troubleshooting**

### Error de Conexión a BD
- Verifica credenciales de MySQL
- Confirma que la base de datos existe
- Revisa que las tablas estén creadas

### Error de CORS
- Asegúrate que los headers CORS estén configurados
- Verifica la configuración del servidor web

### Error 500
- Revisa los logs de PHP del servidor
- Confirma que todas las extensiones estén instaladas
- Verifica sintaxis de los archivos PHP

## 📞 **Soporte**

Si tienes problemas con la configuración, revisa:
1. Los logs del servidor web
2. Los logs de PHP
3. Los logs de MySQL
4. La configuración de firewall/hosting

## 🎯 **Próximos Pasos**

1. ✅ **Completado:** Backend básico para registro y login
2. 🔄 **En desarrollo:** Frontend Flutter conectado
3. 📋 **Pendiente:** Sistema de reset de contraseña
4. 📋 **Pendiente:** Upload de imágenes de perfil
5. 📋 **Pendiente:** Sistema de notificaciones por email
