<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
require_once __DIR__ . '/../vendor/autoload.php';

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Cargar variables de entorno desde .env
$dotenv = Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->load();

$host = $_ENV['DB_HOST'] ?? 'localhost';
$dbname = $_ENV['DB_NAME'] ?? '';
$username = $_ENV['DB_USER'] ?? '';
$password = $_ENV['DB_PASS'] ?? '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos"]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['email'])) {
        http_response_code(400);
        echo json_encode(["error" => "Email es requerido"]);
        exit();
    }
    
    $email = trim($input['email']);
    
    try {
        // Verificar si el email ya existe
        $stmt = $pdo->prepare("SELECT id FROM bo_users WHERE email = ?");
        $stmt->execute([$email]);
        
        $exists = $stmt->fetch() ? true : false;
        
        echo json_encode(["exists" => $exists]);
        
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["error" => "Error del servidor"]);
    }
    
} else {
    http_response_code(405);
    echo json_encode(["error" => "Método no permitido"]);
}
?>
