<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
require_once __DIR__ . '/../vendor/autoload.php';

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Cargar variables de entorno desde .env
$dotenv = Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->load();

$host = $_ENV['DB_HOST'] ?? 'localhost';
$dbname = $_ENV['DB_NAME'] ?? '';
$username = $_ENV['DB_USER'] ?? '';
$password = $_ENV['DB_PASS'] ?? '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos"]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['email']) || !isset($input['temporary_password'])) {
        http_response_code(400);
        echo json_encode(["error" => "Email y contraseña temporal son requeridos"]);
        exit();
    }
    
    $email = trim($input['email']);
    $tempPassword = trim($input['temporary_password']);
    
    try {
        // Llamar al procedimiento almacenado VerifyUserEmail
        $stmt = $pdo->prepare("CALL VerifyUserEmail(?, ?, @success, @message)");
        $stmt->execute([$email, $tempPassword]);
        
        // Obtener los valores de salida
        $result = $pdo->query("SELECT @success as success, @message as message")->fetch(PDO::FETCH_ASSOC);
        
        if ($result['success']) {
            // Obtener datos completos del usuario verificado
            $userQuery = $pdo->prepare("
                SELECT id, first_name, last_name, email, birth_date, 
                       created_at, is_email_verified, interests
                FROM bo_users 
                WHERE email = ? AND is_email_verified = 1
            ");
            $userQuery->execute([$email]);
            $userData = $userQuery->fetch(PDO::FETCH_ASSOC);
            
            if ($userData) {
                http_response_code(200);
                echo json_encode([
                    "success" => true,
                    "message" => "Email verificado exitosamente",
                    "user" => [
                        "id" => $userData['id'],
                        "first_name" => $userData['first_name'],
                        "last_name" => $userData['last_name'],
                        "email" => $userData['email'],
                        "birth_date" => $userData['birth_date'],
                        "created_at" => $userData['created_at'],
                        "is_email_verified" => (bool)$userData['is_email_verified'],
                        "interests" => $userData['interests'] ?? ""
                    ]
                ]);
            } else {
                http_response_code(404);
                echo json_encode(["error" => "Usuario no encontrado"]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["error" => $result['message']]);
        }
        
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["error" => "Error del servidor: " . $e->getMessage()]);
    }
    
} else {
    http_response_code(405);
    echo json_encode(["error" => "Método no permitido"]);
}
?>
